<?php
// Funkcja zwracajca poprawnie zapisan nazw wasn.
function title_upcase($str) {
    // Zamiana pierwszej litery na wielk we wszystkich sowach za pomoc funkcji ucwords.
    $str = ucwords($str);
    
    // Pobranie wszystkich sw z cigu poindeksowanych wedug pozycji.
    $wordlist = str_word_count($str, 2);
    
    // Przetwarzanie w ptli wszystkich sw.
    foreach ($wordlist as $position => $word) {
        // Sowa z poniszej listy powinny by zapisane ma liter:
        switch ($word) {
            case 'A':
            case 'I':
            case 'Na':
            case 'Z':
            case 'W':
            case 'Pod':
            case 'Czyli':
            case 'Lub':
            case 'Do':
            case 'Imieniem':
            case 'Oraz':
            case 'Przez':
                // Zastpienie pierwszego znaku w wyrazie ma liter:
                $lower = strtolower($word);
                $str{$position} = $lower{0};
        }
    }

    // Zwrcenie sformatowanego cigu.
    return $str;
}

$sample = "regionalne mistrzostwa modziey w pice nonej i siatkowej";

// Wykonanie tej funkcji zwrci nastpujcy wynik:
// Regionalne Mistrzostwa Modziey w Pice Nonej i Siatkowej
$upcased = title_upcase($sample);
echo "<pre>{$upcased}</pre>";
?>
